<?php if (!defined('_GNUBOARD_')) exit;

function getIncludedPageURL() {
    $p = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
    $u = $p . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    return $u;
}

function getFacebookShareLink($u) {
    $f = "https://www.facebook.com/sharer.php?u=" . urlencode($u);
    return $f;
}

function getTwitterShareLink($u) {
    $t = "https://twitter.com/intent/tweet?url=" . urlencode($u);
    return $t;
}

function getLineShareLink($u) {
    $m = "라인으로 공유합니다!";
    $l = "https://social-plugins.line.me/lineit/share?url=" . urlencode($u) . "&text=" . urlencode($m);
    return $l;
}

function getPluginImagePath() {
    $p = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
    $h = $_SERVER['HTTP_HOST'];
    $o = $_SERVER['SERVER_PORT'];
    $s = ($o !== 80 && $o !== 443) ? ":" . $o : "";
    $u = $p . $h . $s . "/plugin/sns_share/img";
    return $u;
}

$pi = getPluginImagePath();
$ipu = getIncludedPageURL();
$fs = getFacebookShareLink($ipu);
$ts = getTwitterShareLink($ipu);
$ls = getLineShareLink($ipu);
?>
<script src="//developers.kakao.com/sdk/js/kakao.min.js" charset="utf-8"></script>
<script src="<?php echo G5_JS_URL; ?>/kakaolink.js" charset="utf-8"></script>
<script>
    //카카오 javascript 키\
    Kakao.init("<?php echo $config['cf_kakao_js_apikey']; ?>");
</script>
<script type='text/javascript'>
    //<![CDATA[
    function Kakao_sendLink() {

        var webUrl = location.protocol + "<?php echo '//'.$_SERVER['HTTP_HOST'].'/bbs/board.php?bo_table='.$bo_table.'&wr_id='.$wr_id; ?>",
            imageUrl = $("#bo_v_img").find("img").attr("src") || $("#bo_v_con").find("img").attr("src") || '';

        Kakao.Link.sendDefault({
            objectType: 'feed',

            content: {
                title: "<?php echo strip_tags($view['wr_subject']); ?>",
                description: "<?php echo mb_substr(strip_tags(str_replace('&nbsp;', '', $view['wr_content'])), 0, 35, 'UTF-8'); ?>",
                imageUrl: imageUrl,
                link: {
                    mobileWebUrl: webUrl,
                    webUrl: webUrl
                }
            },

            buttons: [{
                title: '바로가기',
                link: {
                    mobileWebUrl: webUrl,
                    webUrl: webUrl
                }
            }]
        });
    }
    //]]>
</script>

<div id='sns'>
    <a href="javascript:void(0);" id="copyLink"><img src="<?= $pi ?>/url.webp" alt="url 복사" width='50px' height='auto'/></a>
    <a href="javascript:Kakao_sendLink();" class="sns_k"><img src="<?= $pi ?>/kakao.webp" alt="카카오톡 공유" width="50" height='auto'></a>
    <a href="<?= $ls ?>" target="_blank"><img src="<?= $pi ?>/line.webp" alt="라인 공유" width='50px' height='auto'/></a>
    <a href="<?= $fs ?>" target="_blank"><img src="<?= $pi ?>/meta.webp" alt="페이스북 공유" width='50px' height='auto'/></a>
    <a href="<?= $ts ?>" target="_blank"><img src="<?= $pi ?>/x.webp" alt="트위터 공유" width='50px' height='auto'/></a>
</div>
<style>
    #sns {
        display: flex;
        justify-content: center; /* 가로 중앙 정렬 */
        margin: 5px;
        margin-bottom:20px
    }
    #sns img {
        margin-right: 5px;
    }
</style>
<script>
    document.getElementById('copyLink').addEventListener('click', function() {
        var u = '<?= $ipu ?>';
        var t = document.createElement('input');
        t.setAttribute('value', u);
        document.body.appendChild(t);
        t.select();
        document.execCommand('copy');
        document.body.removeChild(t);
        alert('URL이 복사되었습니다.');
    });
</script>
<!--Provided by Tak2 / dsclub.kr-->
<!--본 플러그인은 상업적 이용이 가능합니다만 이미지 자체의 저작권은 각 아이콘 회사와 tak2에게 있으며 본 플러그인을 무단 재배포 할 수 없습니다.-->